package gov.va.med.mhv.sm.admin.service.util;

import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.AdminQueries;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.AdminQueriesSoap;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.Clinic;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.ClinicLookupResponse;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.Provider;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.ProviderLookupResponse;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.SMClinic;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.SMClinicLookupResponse;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.SMNoteTitle;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.SMTIUTitleLookupResponse;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.Team;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.TeamLookupResponse;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.UserLookupResponseNew;
import gov.va.med.mhv.sm.healthshare.wsclient.adminqueries.UserNew;

@Component
public class SMHealthshareDelegate {

	private static final long serialVersionUID = -6203936832402139671L;
	
	private static final Log log = LogFactory.getLog(SMHealthshareDelegate.class);
	
	private final String STATUS_OK = "OK";
	
	@Value("${sm.healthshare.adminqueries.endpointUrl}")
	private String healthShareUrl;
	
	@Value("${sm.healthshare.connect.timeout}")
	private int connectionTimeOut;
	
	@Value("${sm.healthshare.request.timeout}")
	private int requestTimeOut;
	
	@Value("${sm.healthshare.response.timeout}")
	private int responseTimeOut;
	
	@Value("${sm.healthshare.tiutitles.documentClass}")
	private String tiuDocumentClass;
	
	@Value("${sm.healthshare.smclinics.stopCode}")
	private String smClinicsStopCode;
	
	public SMHealthshareDelegate(){
		
	}

	public List<Clinic> getClinicsByName(String name, String station) throws Exception {
		ClinicLookupResponse clinicLookupResponse = getAdminQueriesService().getClinicsByName(name, station);
		List<Clinic> clinicsList = null;
		if(log.isDebugEnabled()){
			log.debug("Clinic Lookup Response status ==>"+clinicLookupResponse.getStatus()+" for name="+name+" station="+station);
		}
		if(clinicLookupResponse!=null && clinicLookupResponse.getStatus().equalsIgnoreCase(STATUS_OK)){
			clinicsList =  clinicLookupResponse.getClinics().getClinic();
		}
		return clinicsList;
	}
	
	public List<Provider> getPCMMProvidersByName(String lastName, String firstName, String station) throws Exception {
		ProviderLookupResponse providerLookupResponse = getAdminQueriesService().getProvidersByNameAndDUZ(lastName, firstName, null, station);
		List<Provider> providersList = null;
		if(log.isDebugEnabled()){
			log.debug("Provider Lookup Response status ==>"+providerLookupResponse.getStatus()+" for name="+lastName+",firstName="+firstName+" station="+station);
		}
		if(providerLookupResponse!=null && providerLookupResponse.getStatus().equalsIgnoreCase(STATUS_OK)){
			providersList =  providerLookupResponse.getProviders().getProvider();
		}
		return providersList;
	}
	
	public List<Team> getOERRTeamsByName(String name, String station) throws Exception {
		TeamLookupResponse teamLookupResponse = getAdminQueriesService().getTeamsByName(name, station);
		List<Team> teamList = null;
		if(log.isDebugEnabled()){
			log.debug("OERR Team Lookup Response status ==>"+teamLookupResponse.getStatus()+" for name="+name+" station="+station);
		}
		if(teamLookupResponse!=null && teamLookupResponse.getStatus().equalsIgnoreCase(STATUS_OK)){
			teamList =  teamLookupResponse.getTeams().getTeam();
		}
		return teamList;
	}
	
	public List<SMClinic> getSMClinicsByName(String name,String station) throws Exception {
		SMClinicLookupResponse smClinicLookupResponse = getAdminQueriesService().getClinicsByNameStopCode(name,station,getSmClinicsStopCode());
		List<SMClinic> smClinicList = null;
		if(log.isDebugEnabled()){
			log.debug("SMClinic Lookup Response status ==>"+smClinicLookupResponse.getStatus()+" for name="+name+" station="+station);
		}
		if(smClinicLookupResponse!=null && smClinicLookupResponse.getStatus().equalsIgnoreCase(STATUS_OK)){
			smClinicList =  smClinicLookupResponse.getClinics().getSMClinic();
		}
		return smClinicList;
	}
	
	public List<SMNoteTitle> getTiuNoteTitlesByFacility(String station) throws Exception {
		SMTIUTitleLookupResponse tiuTitleLookupResponse = getAdminQueriesService().getCPRSTIUTitles(station,getTiuDocumentClass());
		List<SMNoteTitle> tiuNoteTitleList = null;
		if(log.isDebugEnabled()){
			log.debug("Tiu Title Lookup Response status ==>"+tiuTitleLookupResponse.getStatus()+" for="+station+" station="+station);
		}
		if(tiuTitleLookupResponse!=null && tiuTitleLookupResponse.getStatus().equalsIgnoreCase(STATUS_OK)){
			tiuNoteTitleList =  tiuTitleLookupResponse.getSMTIUTitles().getSMNoteTitle();
		}
		return tiuNoteTitleList;
	}
	
	public List<UserNew> getUserByNameAndDuz(String lastName, String firstName, String duz, String station) throws Exception {
		UserLookupResponseNew userLookupResponse = getAdminQueriesService().getNewUserByNameAndDUZ(lastName, firstName, duz, station);
		List<UserNew> usersList = null;
		if(log.isDebugEnabled()){
			log.debug("User Lookup Response status ==>"+userLookupResponse.getStatus()+" for name="+lastName+",firstName="+firstName+" station="+station);
		}
		if(userLookupResponse!=null && userLookupResponse.getStatus().equalsIgnoreCase(STATUS_OK)){
			usersList =  userLookupResponse.getUsers().getUserNew();
		}
		return usersList;
	}
	
	
	
	private AdminQueriesSoap getAdminQueriesService() throws Exception{
		AdminQueries adminQueries = new AdminQueries();
		try{
	    	  AdminQueriesSoap adminQueriesSoap = adminQueries.getAdminQueriesSoap();
	    	  BindingProvider bindingProvider = (BindingProvider) adminQueriesSoap; 
			  bindingProvider.getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, getHealthShareUrl());
			  bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout",  getConnectionTimeOut());
			  bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", getRequestTimeOut());
			  bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.receive.timeout", getResponseTimeOut());
	    	  return adminQueriesSoap;
   	  	}
   	  	catch (WebServiceException webserviceExp) {
	 		if (log.isErrorEnabled()) {
	 			log.error("SMHealthshareDelegate->WebService Exception");
	 			webserviceExp.printStackTrace();
	 		}
   	  	}
   	  	catch(Exception exp){
	   		if (log.isErrorEnabled()) {
	   			log.error("SMHealthshareDelegage->Exception Occured");
	   			exp.printStackTrace();
	   		}
   	  	}
   	  	return null;
     }
	
	public String getHealthShareUrl() {
		return healthShareUrl;
	}


	public void setHealthShareUrl(String healthShareUrl) {
		this.healthShareUrl = healthShareUrl;
	}


	public int getConnectionTimeOut() {
		return connectionTimeOut;
	}


	public void setConnectionTimeOut(int connectionTimeOut) {
		this.connectionTimeOut = connectionTimeOut;
	}


	public int getRequestTimeOut() {
		return requestTimeOut;
	}


	public void setRequestTimeOut(int requestTimeOut) {
		this.requestTimeOut = requestTimeOut;
	}


	public int getResponseTimeOut() {
		return responseTimeOut;
	}


	public void setResponseTimeOut(int responseTimeOut) {
		this.responseTimeOut = responseTimeOut;
	}
	
	public String getTiuDocumentClass() {
		return tiuDocumentClass;
	}

	public void setTiuDocumentClass(String tiuDocumentClass) {
		this.tiuDocumentClass = tiuDocumentClass;
	}

	public String getSmClinicsStopCode() {
		return smClinicsStopCode;
	}

	public void setSmClinicsStopCode(String smClinicsStopCode) {
		this.smClinicsStopCode = smClinicsStopCode;
	}


}
